#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTest.VAL;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
    [TestFixture]
    public class BOL_VbecsProcess : BaseTest 
    {

        private BOL.VbecsProcess[] _VbecsProcesses;
        private BOL.VbecsProcess _tstVP;

        [SetUp]
        protected void SetUp() 
        {
			this.BaseSetUp();

			if (this.RefreshData)
			{
				DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.Unknown);
                this._VbecsProcesses = VbecsProcess.GetAllVbecsProcesses();
				this.RefreshData = false;
            }

			VistALinkUnitTestHarness.RequireConnection();
			this._tstVP = this._VbecsProcesses[0];
        }


		[TearDown]
		protected void TearDown()
		{
			VistALinkUnitTestHarness.ReleaseConnection();
		}

        [Test]
        public void Ctor_DataRow_Pass()
        {
			DataTable dtTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM WorkloadProcess", true);
			BOL.VbecsProcess tmpVP = new BOL.VbecsProcess(dtTest.Rows[0]);

			Assert.IsNotNull(tmpVP);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_DataRow_Fail()
		{
		}

		[Test]
		public void GetWeightMultiplier_Pass()
		{
			DataTable dtTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM WorkloadProcess", true);

			string workloadCode = dtTest.Rows[0][TABLES.WorkloadProcess.WorkloadCode].ToString();
			string weightMultiplier = dtTest.Rows[0][TABLES.WorkloadProcess.WeightMultiplier].ToString();

			string tstValue = BOL.VbecsProcess.GetWeightMultiplier(workloadCode);

			Assert.AreEqual(true, true);
		}

		[Test]
		public void GetWeightMultiplier_Fail()
		{
			string tstValue = BOL.VbecsProcess.GetWeightMultiplier("CRACKERS");
			Assert.AreEqual(string.Empty, tstValue);
		}

		[Test]
		public void CheckDirty_Pass()
		{
			this.RefreshData = true;

			bool tstValue = this._tstVP.CheckDirty();

			Assert.AreEqual(false, tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void CheckDirty_Fail()
		{
		}

		[Test]
		public void GetAllVbecsProcesses_Pass()
		{
			BOL.VbecsProcess[] tstValue = BOL.VbecsProcess.GetAllVbecsProcesses();

			Assert.AreEqual(_VbecsProcesses.Length, tstValue.Length, "VbecsProcess[].Length");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAllVbecsProcesses_Fail()
		{
		}

		[Test]
		public void GetAllVistaWorkloads_Pass()
		{
			DataTable dtTest = BOL.VbecsProcess.GetAllVistaWorkloads();

			Assert.IsTrue(dtTest.Rows.Count > 0);
			Assert.AreEqual(6, dtTest.Columns.Count, "Columns.Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAllVistaWorkloads_Fail()
		{
		}

		[Test]
		public void GetNewWorkLoad_Pass()
		{
			DataTable dtTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM WorkloadProcess", true);
			string workloadCode = dtTest.Rows[0][TABLES.WorkloadProcess.WorkloadCode].ToString();
	
			BOL.WorkLoad tstValue = this._tstVP.GetNewWorkLoad(workloadCode);

			Assert.IsNotNull(tstValue);
			Assert.AreEqual(workloadCode, tstValue.WorkloadCode, "WorkloadCode");
		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetNewWorkLoad_Fail()
		{
			BOL.WorkLoad tstValue = this._tstVP.GetNewWorkLoad("MY BUSCUITS ARE BURNIN");
		}

		[Test]
		public void GetWorkLoad_Pass()
		{
			string sql = "SELECT TOP 1 * FROM WorkloadProcess WP "
				+ " JOIN VbecsProcess VP ON WP.VbecsProcessId = VP.VbecsProcessId "
				+ " AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'";
			//
			DataRow drTest = UnitTestUtil.RunSQLGetDataRow(sql);
			System.Guid wpGuid = (System.Guid)drTest[TABLES.WorkloadProcess.WorkloadProcessGuid];
			//
			BOL.VbecsProcess tempVp = new VbecsProcess(drTest);                                                                   
			//
			BOL.WorkLoad tstValue = tempVp.GetWorkLoad(wpGuid);
			//
			Assert.IsNotNull(tstValue);
			Assert.AreEqual(wpGuid, tstValue.WorkloadProcessGuid, "WorkloadProcessGuid");
		}


		[Test]
		public void GetWorkLoad_Fail()
		{
			Assert.IsNull(this._tstVP.GetWorkLoad(System.Guid.NewGuid()));
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataTable dtTest = new DataTable();
			DataRow dr = dtTest.NewRow();

			DataRow dr2 = this._tstVP.LoadDataRowFromThis(dr);
			Assert.AreEqual(dr, dr2);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}

		[Test]
		public void SaveChanges_Pass()
		{
			this.RefreshData = true;

			this._tstVP.SaveChanges(Common.UpdateFunction.UnitTests);
			
			Assert.IsTrue(true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SaveChanges_Fail()
		{
		}

		[Test]
		public void AddItem_Pass()
		{	
			int countBefore = this._tstVP.WorkLoads.Count;

			DataRow drNewWorkload = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM WorkloadCache WHERE Code_Id > " + new Random().Next(1,199).ToString());

			this._tstVP.AddItem(this._tstVP.GetNewWorkLoad(drNewWorkload[TABLES.WorkloadCache.Lmip].ToString()));
			this._tstVP.SaveChanges(Common.UpdateFunction.UnitTests);

			this._VbecsProcesses = VbecsProcess.GetAllVbecsProcesses();
			foreach(BOL.VbecsProcess tmp1 in this._VbecsProcesses)
			{
				if (tmp1.VbecsProcessGuid == this._tstVP.VbecsProcessGuid)
				{
					this._tstVP = tmp1;
					break;
				}
			}

			Assert.AreEqual(countBefore + 1, this._tstVP.WorkLoads.Count, "Workloads.Count");

			this.RefreshData = true;
		}

		[Test]
		public void AddItem_Fail()
		{
			DataTable dtTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM WorkloadProcess", true);
			string workloadCode = dtTest.Rows[0][TABLES.WorkloadProcess.WorkloadCode].ToString();
	
			BOL.WorkLoad tstValue = this._tstVP.GetNewWorkLoad(workloadCode);
				
			int countBefore = this._tstVP.WorkLoads.Count;
			this._tstVP.AddItem(tstValue);
			Assert.AreEqual(countBefore, this._tstVP.WorkLoads.Count, "Workloads.Count");
		}


		[Test]
		public void VbecsProcessGuid_Pass()
		{
			System.Guid tstValue = this._tstVP.VbecsProcessGuid;

			Assert.AreEqual(tstValue, this._tstVP.VbecsProcessGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void VbecsProcessGuid_Fail()
		{
		}

		[Test]
		public void VbecsProcessId_Pass()
		{
			int tstValue = this._tstVP.VbecsProcessId;

			Assert.AreEqual(tstValue, this._tstVP.VbecsProcessId);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void VbecsProcessId_Fail()
		{
		}

		[Test]
		public void VbecsProcessName_Pass()
		{
			string tstValue = this._tstVP.VbecsProcessName;

			Assert.AreEqual(tstValue, this._tstVP.VbecsProcessName);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void VbecsProcessName_Fail()
		{
		}

		[Test]
		public void WorkLoads_Pass()
		{
			DataView tstValue = this._tstVP.WorkLoads;

			Assert.AreEqual(tstValue, this._tstVP.WorkLoads);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void WorkLoads_Fail()
		{
		}

		[Test]
		public void DivisionCode_Pass()
		{
			Assert.AreEqual(UnitTestConfig.TestDivisionCode, this._tstVP.DivisionCode);
		}

		[Test]
		[ExpectedException(typeof(ArgumentNullException))]
		public void DivisionCode_Fail()
		{
			this._tstVP.DivisionCode = null;
		}

    }
}
#endif

